import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { Button } from "@/components/ui/button";
import { 
  Shield, 
  CheckCircle, 
  Phone, 
  Mail,
  Users,
  Ruler,
  Clock,
  Wrench
} from "lucide-react";
import Link from "next/link";

export default function SecurityCabinPage() {
  const securityModels = [
    {
      name: "FS-001 Security Cabin",
      description: "Standard security cabin for single guard duty",
      dimensions: "3m x 2m x 2.5m (H)",
      capacity: "1 person",
      features: ["Security Windows", "Reinforced Door", "Ventilation", "Electrical Points", "Weather Resistant"]
    },
    {
      name: "FS-002 Security Cabin", 
      description: "Enhanced security cabin for 2-person duty",
      dimensions: "4m x 2.4m x 2.8m (H)",
      capacity: "2 persons",
      features: ["Dual Workstations", "Enhanced Security", "Better Insulation", "Storage Space", "Emergency Exit"]
    },
    {
      name: "Security Cabin with Toilet",
      description: "Complete solution with attached toilet facility",
      dimensions: "4m x 2.4m x 2.8m (H)",
      capacity: "2-3 persons",
      features: ["Guard Room", "Attached Toilet", "Washbasin", "Privacy Partition", "Extended Duty Ready"]
    }
  ];

  const specifications = [
    "Reinforced steel frame construction",
    "Security-grade windows with bars",
    "Heavy-duty locks and latches", 
    "Weather-resistant exterior coating",
    "Insulated walls and roof",
    "Electrical installation ready",
    "Ventilation system included",
    "Non-slip flooring",
    "Emergency communication points",
    "Easy relocation capability"
  ];

  const applications = [
    "Construction site security",
    "Industrial facility gatekeeping",
    "Parking lot monitoring",
    "Event security checkpoints",
    "Warehouse perimeter security",
    "Residential complex entry points",
    "Government facility security",
    "Airport and port security"
  ];

  return (
    <div className="min-h-screen">
      {/* Hero Section */}
      <section className="relative py-20 bg-gradient-to-r from-blue-900/80 to-gray-900/80">
        <div className="absolute inset-0 bg-black/40"></div>
        <div className="absolute inset-0">
          <div className="w-full h-full bg-gradient-to-br from-blue-800 via-gray-800 to-slate-800"></div>
        </div>
        
        <div className="relative z-20 container mx-auto px-4 text-center text-white">
          <h1 className="text-4xl md:text-6xl font-bold mb-6">
            Security Cabins
          </h1>
          <p className="text-xl md:text-2xl max-w-3xl mx-auto">
            Professional Security Solutions for Every Need
          </p>
        </div>
      </section>

      {/* Product Overview */}
      <section className="py-16 bg-white">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto text-center mb-16">
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-6">
              Secure & Reliable Guard Cabins
            </h2>
            <p className="text-lg text-gray-700 leading-relaxed mb-6">
              Our security cabins are designed for professional security operations across UAE. 
              Whether you need a single-person guard post or a multi-person security facility, 
              we provide robust, weather-resistant solutions built to withstand UAE's climate conditions.
            </p>
          </div>

          {/* Security Models Grid */}
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-16">
            {securityModels.map((model, index) => (
              <Card key={index} className="overflow-hidden hover:shadow-lg transition-shadow">
                <div className="relative h-48 bg-gradient-to-br from-blue-800 to-gray-800">
                  <Badge className="absolute top-4 left-4 bg-blue-600">
                    Security Solution
                  </Badge>
                </div>
                
                <CardHeader>
                  <CardTitle className="text-xl font-bold">{model.name}</CardTitle>
                  <CardDescription>{model.description}</CardDescription>
                </CardHeader>
                
                <CardContent>
                  <div className="space-y-3 mb-4">
                    <div className="flex items-center text-sm text-gray-600">
                      <Ruler className="h-4 w-4 mr-2" />
                      <span>{model.dimensions}</span>
                    </div>
                    <div className="flex items-center text-sm text-gray-600">
                      <Users className="h-4 w-4 mr-2" />
                      <span>{model.capacity}</span>
                    </div>
                  </div>

                  <div className="mb-4">
                    <h4 className="text-sm font-semibold text-gray-900 mb-2">Key Features:</h4>
                    <div className="space-y-1">
                      {model.features.slice(0, 3).map((feature, idx) => (
                        <div key={idx} className="flex items-center text-sm text-gray-600">
                          <CheckCircle className="h-3 w-3 mr-2 text-green-600" />
                          <span>{feature}</span>
                        </div>
                      ))}
                    </div>
                  </div>
                  
                  <Button className="w-full bg-blue-600 hover:bg-blue-700">
                    <Phone className="mr-2 h-4 w-4" />
                    Get Quote
                  </Button>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Specifications & Applications */}
      <section className="py-16 bg-gray-50">
        <div className="container mx-auto px-4">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12">
            {/* Specifications */}
            <div>
              <h2 className="text-3xl font-bold text-gray-900 mb-6 flex items-center">
                <Wrench className="h-8 w-8 mr-3 text-blue-600" />
                Technical Specifications
              </h2>
              <div className="space-y-3">
                {specifications.map((spec, index) => (
                  <div key={index} className="flex items-start space-x-3">
                    <CheckCircle className="h-5 w-5 text-blue-600 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">{spec}</span>
                  </div>
                ))}
              </div>
              
              <Card className="mt-8 bg-blue-50 border-blue-200">
                <CardContent className="p-6">
                  <h3 className="text-lg font-semibold text-blue-900 mb-3">Quality Assurance</h3>
                  <p className="text-blue-800 text-sm">
                    All security cabins are manufactured with high-grade materials and undergo 
                    rigorous quality testing to ensure durability in UAE's harsh climate conditions.
                  </p>
                </CardContent>
              </Card>
            </div>

            {/* Applications */}
            <div>
              <h2 className="text-3xl font-bold text-gray-900 mb-6 flex items-center">
                <Shield className="h-8 w-8 mr-3 text-green-600" />
                Applications
              </h2>
              <div className="grid grid-cols-1 sm:grid-cols-2 gap-4">
                {applications.map((application, index) => (
                  <Card key={index} className="p-4 hover:shadow-md transition-shadow">
                    <div className="flex items-center space-x-3">
                      <div className="w-2 h-2 bg-green-600 rounded-full"></div>
                      <span className="text-gray-700 font-medium">{application}</span>
                    </div>
                  </Card>
                ))}
              </div>

              <Card className="mt-8 bg-green-50 border-green-200">
                <CardContent className="p-6">
                  <div className="flex items-center mb-3">
                    <Clock className="h-5 w-5 text-green-600 mr-2" />
                    <h3 className="text-lg font-semibold text-green-900">Fast Deployment</h3>
                  </div>
                  <p className="text-green-800 text-sm">
                    Our security cabins can be manufactured and delivered within few days. 
                    Professional installation service available across all UAE Emirates.
                  </p>
                </CardContent>
              </Card>
            </div>
          </div>
        </div>
      </section>

      {/* Call to Action */}
      <section className="py-16 bg-blue-800 text-white">
        <div className="container mx-auto px-4 text-center">
          <h2 className="text-3xl md:text-4xl font-bold mb-4">
            Need a Security Cabin Solution?
          </h2>
          <p className="text-xl mb-8 max-w-2xl mx-auto">
            Contact us for a customized security cabin solution. Our team will help you choose 
            the right model for your specific security requirements.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button size="lg" className="bg-white text-blue-800 hover:bg-gray-100 px-8">
              <Phone className="mr-2 h-5 w-5" />
              Call: +971 58 201 2073
            </Button>
            <Button size="lg" variant="outline" className="border-white text-white hover:bg-white/10 px-8" asChild>
              <Link href="/contact">
                <Mail className="mr-2 h-5 w-5" />
                Request Quote
              </Link>
            </Button>
          </div>
        </div>
      </section>
    </div>
  );
}